package gov.va.med.mhv.usermgmt.data.repository;

import java.util.Date;
import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.common.data.model.UserProfile;

@Repository
public interface UserProfileRepository extends JpaRepository<UserProfile, Long> {

	@Query("select u from UserProfile u where lower(u.userName) = lower(:userName)")
	UserProfile findByUserName(@Param("userName") String userName);

	@Query("select u from UserProfile u where u.id = :id")
	UserProfile getUserProfileById(@Param("id") Long id);

	@Query("Select u from UserProfile u where u.userName like :userName")
	List<UserProfile> findByUserNameLike(@Param("userName") String userName);

	@Query("Select u from UserProfile u where u.firstName = :firstName and u.lastName = :lastName and u.birthDate= :birthDate and u.ssn=:ssn and u.id=:id")
	List<UserProfile> getProfileByNameBirthDateSsnExcludeId(@Param("firstName") String firstName,
			@Param("lastName") String lastName, @Param("birthDate") Date birthDate, @Param("ssn") String ssn,
			@Param("id") Long id);

	@Query("Select u from UserProfile u where ((:firstName is null and u.firstName is null) or (:firstName = '%' and u.firstName is null) or (:firstName is not null "
			+ "and lower(u.firstName) = :firstName)) and lower(u.lastName) like :lastName and u.birthDate = :birthDate and ((:ssn is null and u.ssn is null) "
			+ "or (:ssn = '%' and u.ssn is null) or (:ssn is not null and u.ssn like :ssn ))")
	List<UserProfile> getProfileByNameBirthDateSsnIncludedDeleted(@Param("firstName") String firstName,
			@Param("lastName") String lastName, @Param("birthDate") Date birthDate, @Param("ssn") String ssn);

	@Query("Select u from UserProfile u where lower(u.firstName) =lower(:firstName) and lower(u.lastName)  = lower(:lastName) and u.birthDate= :birthDate and u.ssn=:ssn")
	List<UserProfile> getProfileByNameBirthDateSsn(@Param("firstName") String firstName,
			@Param("lastName") String lastName, @Param("birthDate") Date birthDate, @Param("ssn") String ssn);

	@Query("Select u from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName) and u.gender= :gender and u.birthDate= :birthDate")
	List<UserProfile> getProfileByNameBirthDate(@Param("firstName") String firstName,
			@Param("lastName") String lastName, @Param("gender") String gender, @Param("birthDate") Date birthDate);

	@Query("Select u from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName) and u.gender= :gender and u.gender= :gender")
	List<UserProfile> getProfileByNameBirthDateForVAAFI(@Param("firstName") String firstName,
			@Param("lastName") String lastName, @Param("gender") String gender);

	@Query("Select u from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName) and lower(u.userName) = lower(:userName) and u.gender= :gender and u.birthDate = :birthDate")
	List<UserProfile> getProfileByNameUserNameBirthDate(@Param("firstName") String firstName,
			@Param("lastName") String lastName, @Param("userName") String userName, @Param("gender") String gender,
			@Param("birthDate") Date birthDate);

	@Query("Select u from UserProfile u where u.birthDate= :birthDate and u.ssn=:ssn and lower(u.firstName) = lower(:firstName) "
			+ "and lower(u.lastName) = lower(:lastName) and u.deactivationReason is null")
	List<UserProfile> getActiveProfileByBirthDateSSN(@Param("birthDate") Date birthDate, @Param("ssn") String ssn,
			@Param("firstName") String firstName, @Param("lastName") String lastName);

	// match by name, birthdate, gender
	@Query("Select count(u) from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName)"
			+ " and u.birthDate= :birthDate and u.gender= :gender")
	Long getProfileByNameBirthDateCount(@Param("firstName") String firstName, @Param("lastName") String lastName,
			@Param("birthDate") Date birthDate, @Param("gender") String gender);

	// match by name, birthdate, gender, last 4 SSN (123-45-6789)
	@Query("Select u from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName)"
			+ " and u.birthDate= :birthDate and u.gender= :gender and substring(u.ssn, 8, 4) = trim(:ssn)")
	List<UserProfile> getProfileByNameBirthDateSSN(@Param("firstName") String firstName, @Param("lastName") String lastName,
			@Param("birthDate") Date birthDate, @Param("gender") String gender, @Param("ssn") String ssn);

	@Query("Select count(u) from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName)"
			+ " and u.birthDate= :birthDate and u.gender= :gender and substring(u.ssn, 8, 4) = trim(:ssn)")
	Long getProfileByNameBirthDateSSNCount(@Param("firstName") String firstName, @Param("lastName") String lastName,
			@Param("birthDate") Date birthDate, @Param("gender") String gender, @Param("ssn") String ssn);

	// match by name, birthdate, gender, contact email
	@Query("Select u from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName)"
			+ " and u.birthDate= :birthDate and u.gender= :gender and lower(trim(u.contactInfoEmail)) = lower(trim(:email))")
	List<UserProfile> getProfileByNameBirthDateEmail(@Param("firstName") String firstName, @Param("lastName") String lastName,
			@Param("birthDate") Date birthDate, @Param("gender") String gender, @Param("email") String email);

	@Query("Select count(u) from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName)"
			+ " and u.birthDate= :birthDate and u.gender= :gender and lower(trim(u.contactInfoEmail)) = lower(trim(:email))")
	Long getProfileByNameBirthDateEmailCount(@Param("firstName") String firstName, @Param("lastName") String lastName,
			@Param("birthDate") Date birthDate, @Param("gender") String gender, @Param("email") String email);

	// match by name, birthdate, gender, phone
	@Query("Select u from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName)"
			+ " and u.birthDate= :birthDate and u.gender= :gender and (trim(u.contactInfoHomePhone) = trim(:phone)"
			+ " or trim(u.contactInfoFax) = trim(:phone) or trim(u.contactInfoMobilePhone) = trim(:phone)"
			+ " or trim(u.contactInfoPager) = trim(:phone) or trim(u.contactInfoWorkPhone) = trim(:phone) )")
	List<UserProfile> getProfileByNameBirthDatePhone(@Param("firstName") String firstName, @Param("lastName") String lastName,
			@Param("birthDate") Date birthDate, @Param("gender") String gender, @Param("phone") String phone);

	@Query("Select count(u) from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName)"
			+ " and u.birthDate= :birthDate and u.gender= :gender and (trim(u.contactInfoHomePhone) = trim(:phone)"
			+ " or trim(u.contactInfoFax) = trim(:phone) or trim(u.contactInfoMobilePhone) = trim(:phone)"
			+ " or trim(u.contactInfoPager) = trim(:phone) or trim(u.contactInfoWorkPhone) = trim(:phone) )")
	Long getProfileByNameBirthDatePhoneCount(@Param("firstName") String firstName, @Param("lastName") String lastName,
			@Param("birthDate") Date birthDate, @Param("gender") String gender, @Param("phone") String phone);

	@Query("Select count(u) from UserProfile u where ((:firstName is null and u.firstName is null) or (:firstName = '%' and u.firstName is null) or (:firstName is not null "
			+ "and lower(u.firstName) = lower(:firstName))) and lower(u.lastName) like lower(:lastName) and u.birthDate = :birthDate and ((:ssn is null and u.ssn is null) "
			+ "or (:ssn = '%' and u.ssn is null) or (:ssn is not null and u.ssn like :ssn ))")
	Long getProfileByNameBirthDateSsnCount(@Param("firstName") String firstName,
			@Param("lastName") String lastName, @Param("birthDate") Date birthDate, @Param("ssn") String ssn);

	@Query("select u from UserProfile u where " +
			"u.isPatient = 0 " +
			"and u.isVeteran = 0 " +
			"and u.isChampVABeneficiary = 1 " +
			"and u.deactivationReason is null " )
	public Page<UserProfile> getUnmatchedChampVAUsers(Pageable pageRequest);

}
